<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- NavBar Global variables -->
	<xsl:variable name="gOverview">
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'OverviewNavBar'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="gPackage">
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'PackageNavBar'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="gClass">
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'ClassNavBar'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="gTree">
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'TreeNavBar'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="gUse">
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'UseNavBar'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="gIndex">
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'IndexNavBar'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="gHelp">
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'HelpNavBar'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	
	<xsl:variable name="gPrev">
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'Prev'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="gNext">
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'Next'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	

	<!-- Calculate relative path prefix -->
	<xsl:template name="RelativePathPrefix">
		<xsl:param name="element"></xsl:param>
		<xsl:variable name="elementPath">
			<xsl:call-template name="pathResolver">
				<xsl:with-param name="element" select="$element"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="relative" select="substring-after(string($elementPath), $outdir)"></xsl:variable>
		<xsl:variable name="relativePrefix">
			<xsl:call-template name="RelativePrefix">
				<xsl:with-param name="path" select="substring-after($relative, '/')"></xsl:with-param>
				<xsl:with-param name="prefix" select="''"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="$relativePrefix"></xsl:value-of>		
	</xsl:template>
	
	<!-- Print NavBar Cell -->
	<xsl:template name="NavBarCell">
		<xsl:param name="name"></xsl:param>
		<xsl:param name="link"></xsl:param>
		<xsl:param name="bold"></xsl:param>
		<xsl:param name="relativePrefix"></xsl:param>
		
		<xsl:choose>
			<xsl:when test="$link">
				<td class="NavBarCellCommon">
				<xsl:variable name="index-all" select="concat($relativePrefix, $link)"></xsl:variable>
				<a href="{$index-all}">
				<font size="+1" class="NavBarFont1">
				<b><xsl:value-of select="$name"></xsl:value-of></b></font></a>
				<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</xsl:when>
			<xsl:when test="$bold">
				<td class="NavBarCellCommonRev">
				<font size="+1" class="NavBarFont1">
				<b><xsl:value-of select="$name"></xsl:value-of></b></font>
				<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="NavBarCellCommon">
				<font size="+1" class="NavBarFont1">
				<xsl:value-of select="$name"></xsl:value-of>
				</font>
				<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- Print Header/Footer areas -->
	<xsl:template name="header_footer">
		<xsl:param name="header"></xsl:param>
		<td align="right" valign="top" rowspan="3">
		<em>
		<xsl:choose>
			<xsl:when test="$header">
				<xsl:value-of select="$header_param"></xsl:value-of>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$footer_param"></xsl:value-of>
			</xsl:otherwise>
		</xsl:choose>
		</em>
		</td>
	</xsl:template>
	
	<!-- Print Frames areas -->
	<xsl:template name="Frames">
		<xsl:param name="ref"></xsl:param>
		<xsl:param name="relativePrefix"></xsl:param>

		<xsl:variable name="frames">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'Frames'"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="noframes">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'NoFrames'"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>

		<!-- Frames -->
		<td class="NavBarCellPrevNext">
		<font size="-2">  
		<xsl:variable name="index" select="concat($relativePrefix, 'index.html')"></xsl:variable>
		<a href="{$index}" target="_top"><b><xsl:value-of select="$frames"></xsl:value-of></b></a>  

		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>

		<!-- No Frames-->
		<a href="{$ref}" target="_top"><b><xsl:value-of select="$noframes"></xsl:value-of></b></a>
		</font>
		</td>
	</xsl:template>
		

</xsl:stylesheet>

  